import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { queryResponse } from "../../../util/processResponse.js";

const initialState = {
    myRefundsWallet: [],
    loading: true,
    isRefresh: false,
};

export const getMyRefundWallet = createAsyncThunk(
    "user/getMyRefundWallet",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);

const getMyRefundWalletSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetRefundWallet: (state) => {
            state.myRefundsWallet = [];
            state.loading = true;
            state.isRefresh = false;
        },
        fetchRefundStart: (state) => {
            state.isRefresh = true;
        },
        getMyRefundWalletSuccree: (state, { payload }) => {
            state.myRefundsWallet = payload;
            state.loading = false;
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyRefundWallet.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyRefundWallet.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.myRefundsWallet = records.data;
            }
            state.loading = false;
        });
        builder.addCase(getMyRefundWallet.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { resetRefundWallet, fetchRefundStart, getMyRefundWalletSuccree } =
    getMyRefundWalletSlice.actions;
export default getMyRefundWalletSlice.reducer;
